//DrawFloorTwo.scad;

//This version 2021_12_30;

//The case has two floors:

//The lower floor carries the fillers for 
//the USB and DC holes, but not the 
//mounting posts for the UNO;

//The upper floor carries the mounting 
//posts for the UNO;
//The holes in these posts extent right thru 
//the floor and are tapped right thru too;
//This simplifies the tapping;

//The holes in the BL, BR, TR mounting posts 
//are PostHoleBigPhi = 2.5mm, 
//ready to be tapped for a 3mm screw;
//The hole in the TL mounting post 
//is PostHoleSmallPhi = 2.0mm, 
//ready to be tapped for a 2.5mm screw;

//This is FloorTwo, the upper floor;

include <UNO_Dimensions.scad>;
use <UNO_Floor.scad>;
use <UNO_FloorMountingPosts.scad>;
use <UNO_FloorMountingPostHoles.scad>;
use <UNO_FloorMagnetRecesses.scad>;
use <UNO_LidHoles.scad>;
use <UNO_LidScrewThreads.scad>;
use <UNO_LidScrewHeads.scad>;

ThreadHole = LidScrewThreadPhi +Whisker;

//color("Blue")     
//translate([USBfillerX -Whisker/2, 
//    0, -FloorZ])
//    LidHoles();

//color("Blue")     
//translate([0, 0, -FloorZ])
//    FloorMagnetRecesses();

difference()
{
    Floor();
    LidScrewThreads(ThreadHole);
    FloorMountingPostHoles();
    translate([0, 0, -FloorZ])
    FloorMagnetRecesses();
    translate([USBfillerX -Whisker/2, 0, -FloorZ])
    LidHoles();

}

//color("Blue") FloorMountingPostHoles();

difference()
{
    FloorMountingPosts();
    FloorMountingPostHoles();
}
//
